program p_9_4;

{// D O L O N C Z O N E   M O D U L Y
{///////////////////////////////////////}
uses crt, graf_fx;

{// Z M I E N N E   G L O B A L N E
{///////////////////////////////////////}
const
szescian : array[0..11] of trojkat = (

{t1}   ((x:-15.0; y:-15.0; z:-15.0; u: 127; v: 0;   kolor: 2),  {0}
        (x:-15.0; y: 15.0; z:-15.0; u: 127; v: 127; kolor: 2),  {2}
        (x: 15.0; y: 15.0; z:-15.0; u: 0;   v: 127; kolor: 2)), {3}

{t2}   ((x: 15.0; y: 15.0; z:-15.0; u: 0;   v: 127; kolor: 4),   {3}
        (x: 15.0; y:-15.0; z:-15.0; u: 0;   v: 0;   kolor: 4),   {1}
        (x:-15.0; y:-15.0; z:-15.0; u: 127; v: 0;   kolor: 4)),  {0}

{t3}   ((x:-15.0; y:-15.0; z: 15.0; u: 0;   v: 0;   kolor: 3),   {4}
        (x: 15.0; y:-15.0; z: 15.0; u: 127; v: 0;   kolor: 3),   {5}
        (x: 15.0; y: 15.0; z: 15.0; u: 127; v: 127; kolor: 3)),  {7}

{t4}   ((x: 15.0; y: 15.0; z: 15.0; u: 127; v: 127; kolor: 6),   {7}
        (x:-15.0; y: 15.0; z: 15.0; u: 0;   v: 127; kolor: 6),   {6}
        (x:-15.0; y:-15.0; z: 15.0; u: 0;   v: 0;   kolor: 6)),  {4}

{t5}   ((x:-15.0; y:-15.0; z:-15.0; u: 0;   v: 0;   kolor: 7),   {0}
        (x: 15.0; y:-15.0; z:-15.0; u: 127; v: 0;   kolor: 7),   {1}
        (x: 15.0; y:-15.0; z: 15.0; u: 127; v: 127; kolor: 7)),  {5}

{t6}   ((x: 15.0; y:-15.0; z: 15.0; u: 127; v: 127; kolor: 8),   {5}
        (x:-15.0; y:-15.0; z: 15.0; u: 0;   v: 127; kolor: 8),   {4}
        (x:-15.0; y:-15.0; z:-15.0; u: 0;   v: 0;   kolor: 8)),  {0}

{t7}   ((x: 15.0; y:-15.0; z:-15.0; u: 0;   v: 0;   kolor: 9),   {1}
        (x: 15.0; y: 15.0; z:-15.0; u: 127; v: 0;   kolor: 9),   {3}
        (x: 15.0; y: 15.0; z: 15.0; u: 127; v: 127; kolor: 9)),  {7}

{t8}   ((x: 15.0; y: 15.0; z: 15.0; u: 127; v: 127; kolor: 11),  {7}
        (x: 15.0; y:-15.0; z: 15.0; u: 0;   v: 127; kolor: 11),  {5}
        (x: 15.0; y:-15.0; z:-15.0; u: 0;   v: 0;   kolor: 11)), {1}

{t9}   ((x: 15.0; y: 15.0; z:-15.0; u: 0;   v: 0;   kolor: 12),  {3}
        (x:-15.0; y: 15.0; z:-15.0; u: 127; v: 0;   kolor: 12),  {2}
        (x:-15.0; y: 15.0; z: 15.0; u: 127; v: 127; kolor: 12)), {6}

{t10}  ((x:-15.0; y: 15.0; z: 15.0; u: 127; v: 127; kolor: 13),  {6}
        (x: 15.0; y: 15.0; z: 15.0; u: 0;   v: 127; kolor: 13),  {7}
        (x: 15.0; y: 15.0; z:-15.0; u: 0;   v: 0;   kolor: 13)), {3}

{t11}  ((x:-15.0; y: 15.0; z:-15.0; u: 0;   v: 0;   kolor: 14),  {2}
        (x:-15.0; y:-15.0; z:-15.0; u: 127; v: 0;   kolor: 14),  {0}
        (x:-15.0; y:-15.0; z: 15.0; u: 127; v: 127; kolor: 14)), {4}

{t12}  ((x:-15.0; y:-15.0; z: 15.0; u: 127; v: 127; kolor: 15),  {4}
        (x:-15.0; y: 15.0; z: 15.0; u: 0;   v: 127; kolor: 15),  {6}
        (x:-15.0; y: 15.0; z:-15.0; u: 0;   v: 0;   kolor: 15))  {2}
  );

var
bufor_t : array[0..19] of trojkat;
bufor_w_roboczy : array[0..100] of wierzcholek;
bufor_t_roboczy : array[0..100] of trojkat;
liczba_widocznych_t : word;
lancuch_znakow : string;
klawisz : char;
adres_2_bufora : pointer;
kat_ox, kat_oy, kat_oz : integer;       {kat obrotu obiektu}
delta_kx, delta_ky, delta_kz : integer; {zmiana predkosci obrotu obiektu}
p_ox, p_oy, p_oz : integer;             {przesuniecie obiektu}
sterownik : byte;
jaki_kolor : boolean;
swiatlo : wierzcholek;  {wektor wskazujacy kierunek padania swiatla}
licznik_k : byte;
tekstura : obraz;
szciezka_do_t : string;

{// P R O C E D U E R Y
{///////////////////////////////////////}

procedure statystyka;
begin

{kat_ox}
g_wyswietl_tekst_13h(adres_2_bufora, 0, 0, 'kat_ox:', 5);
str(kat_ox, lancuch_znakow);
g_wyswietl_tekst_13h(adres_2_bufora, 60, 0, lancuch_znakow, 5);
{kat_oy}
g_wyswietl_tekst_13h(adres_2_bufora, 0, 8, 'kat_oy:', 5);
str(kat_oy, lancuch_znakow);
g_wyswietl_tekst_13h(adres_2_bufora, 60, 8, lancuch_znakow, 5);
{kat_oz}
g_wyswietl_tekst_13h(adres_2_bufora, 0, 16, 'kat_oz:', 5);
str(kat_oz, lancuch_znakow);
g_wyswietl_tekst_13h(adres_2_bufora, 60, 16, lancuch_znakow, 5);
{delta_kx}
g_wyswietl_tekst_13h(adres_2_bufora, 0, 24, 'd_kx:', 5);
str(delta_kx, lancuch_znakow);
g_wyswietl_tekst_13h(adres_2_bufora, 40, 24, lancuch_znakow, 5);
{delta_ky}
g_wyswietl_tekst_13h(adres_2_bufora, 0, 32, 'd_ky:', 5);
str(delta_ky, lancuch_znakow);
g_wyswietl_tekst_13h(adres_2_bufora, 40, 32, lancuch_znakow, 5);
{delta_kz}
g_wyswietl_tekst_13h(adres_2_bufora, 0, 40, 'd_kz:', 5);
str(delta_kz, lancuch_znakow);
g_wyswietl_tekst_13h(adres_2_bufora, 40, 40, lancuch_znakow, 5);
{p_ox}
g_wyswietl_tekst_13h(adres_2_bufora, 0, 48, 'p_ox:', 5);
str(p_ox, lancuch_znakow);
g_wyswietl_tekst_13h(adres_2_bufora, 40, 48, lancuch_znakow, 5);
{p_oy}
g_wyswietl_tekst_13h(adres_2_bufora, 0, 56, 'p_oy:', 5);
str(p_oy, lancuch_znakow);
g_wyswietl_tekst_13h(adres_2_bufora, 40, 56, lancuch_znakow, 5);
{p_oz}
g_wyswietl_tekst_13h(adres_2_bufora, 0, 64, 'p_oz:', 5);
str(p_oz, lancuch_znakow);
g_wyswietl_tekst_13h(adres_2_bufora, 40, 64, lancuch_znakow, 5);
{liczba_widocznych_w}
g_wyswietl_tekst_13h(adres_2_bufora, 0, 73, 'l_w_t:', 5);
str(liczba_widocznych_t, lancuch_znakow);
g_wyswietl_tekst_13h(adres_2_bufora, 50, 73, lancuch_znakow, 5);
{widocznosc_t}
g_wyswietl_tekst_13h(adres_2_bufora, 0, 81, 'w_t:', 5);
str(widocznosc_t, lancuch_znakow);
g_wyswietl_tekst_13h(adres_2_bufora, 30, 81, lancuch_znakow, 5);
{odleglosc_do_PR}
g_wyswietl_tekst_13h(adres_2_bufora, 0, 89, 'PR:', 5);
str(odleglosc_do_PR:2:0, lancuch_znakow);
g_wyswietl_tekst_13h(adres_2_bufora, 30, 89, lancuch_znakow, 5);
{sterownik}
g_wyswietl_tekst_13h(adres_2_bufora, 0, 97, 'stero:', 5);
str(sterownik, lancuch_znakow);
g_wyswietl_tekst_13h(adres_2_bufora, 50, 97, lancuch_znakow, 5);
{jaki_kolor}
if(jaki_kolor = TRUE) then
g_wyswietl_tekst_13h(adres_2_bufora, 0, 105, 'jaki_k: TRUE', 5) else
g_wyswietl_tekst_13h(adres_2_bufora, 0, 105, 'jaki_k: FALSE', 5);
{p_obcinania}
g_wyswietl_tekst_13h(adres_2_bufora, 0, 113, 'p_ob:', 5);
str(p_obcinania:2:2, lancuch_znakow);
g_wyswietl_tekst_13h(adres_2_bufora, 40, 113, lancuch_znakow, 5)

end; {koniec procedure statystyka}

{--------------}

procedure klawisze;
begin

{odczytanie znaku nacisnietego klawisza}
klawisz := readkey;

{delta_kx - predkosc obrotu wokol osi X}
if(klawisz = 'q') then
  if(delta_kx > -2) then dec(delta_kx);
if(klawisz = 'w') then
  if(delta_kx <  2) then inc(delta_kx);

{delta_ky - predkosc obrotu wokol osi Y}
if(klawisz = 'a') then
  if(delta_ky > -2) then dec(delta_ky);
if(klawisz = 's') then
  if(delta_ky <  2) then inc(delta_ky);

{delta_kz - predkosc obrotu wokol osi Z}
if(klawisz = 'z') then
  if(delta_kz > -2) then dec(delta_kz);
if(klawisz = 'x') then
  if(delta_kz <  2) then inc(delta_kz);

{p_ox - przesuniecie obiektu na osi X}
if(klawisz = 'e') then
  if(p_ox > -200) then p_ox := p_ox - 2;
if(klawisz = 'r') then
  if(p_ox <  200) then p_ox := p_ox + 2;

{p_oy - przesuniecie obiektu na osi Y}
if(klawisz = 'd') then
  if(p_oy > -200) then p_oy := p_oy - 2;
if(klawisz = 'f') then
  if(p_oy <  200) then p_oy := p_oy + 2;


{p_oz - przesuniecie obiektu na osi Z}
if(klawisz = 'c') then
  if(p_oz > -200) then p_oz := p_oz - 2;
if(klawisz = 'v') then
  if(p_oz <  200) then p_oz := p_oz + 2;

{widocznosc_t - okreslenie widocznosci trojkatow}
if(klawisz = 't') then widocznosc_t := 1;
if(klawisz = 'y') then widocznosc_t := 2;
if(klawisz = 'u') then widocznosc_t := 3;

{przywrocenie poczatkowego ustawienia}
if(klawisz = 'm') then
begin
kat_ox := 0;
kat_oy := 0;
kat_oz := 0;
p_ox := 0;
p_oy := 0;
p_oz := 80;
delta_kx := 0;
delta_ky := 0;
delta_kz := 0;
end;

{odleglosc_do_PR - oddalenie plaszczyzny rzutowania}
if(klawisz = 'g') then
  if(odleglosc_do_PR > 64) then odleglosc_do_PR := odleglosc_do_PR / 2;
if(klawisz = 'h') then
  if(odleglosc_do_PR < 256) then odleglosc_do_PR := odleglosc_do_PR * 2;

{wybor sposobu wyswietlania szescianu}
if(klawisz = '1') then sterownik := 1; {metoda punktowa}
if(klawisz = '2') then sterownik := 2; {metoda siatkowa}
if(klawisz = '3') then sterownik := 3; {metoda jednokolorowych t.}
if(klawisz = '4') then
begin
   sterownik := 4; {metoda t. cieniowanych plasko}
   {przygotowanie 20 wzorcow koloru dla trojkatow rysowanych metoda
   cieniowania plaskiego}
   for licznik_k := 0 to 19 do
   g_ustaw_wzorzec_koloru(licznik_k + 160, 0, 10 + licznik_k * 2, 0);
end;

if(klawisz = '5') then
begin
   sterownik := 5;          {metoda t. teksturowanych}
   g_laduj_palete_BMP(szciezka_do_t);
end;

if((sterownik >= 1) and (sterownik <= 4)) then
   begin
   {ustawiamy kolor czwartego wzorca koloru na jasnozielony
   a piatego na jasnozolty}
   g_ustaw_wzorzec_koloru(4, 0, 63, 0);
   g_ustaw_wzorzec_koloru(5, 63, 63, 0);
   end;


{p_obcinania}
if(klawisz = 'b') then
  if(p_obcinania > 5.0) then p_obcinania := p_obcinania - 2.0;
if(klawisz = 'n') then
  if(p_obcinania < 100.01) then p_obcinania := p_obcinania + 2.0;

{obrot wektora swiatlo}
if(klawisz = 'k') then
  g_obroc_wierzcholki_wokol_osi_y(@swiatlo, 5, 1);

{wybieramy kolor trojkatow}
if(klawisz = 'j') then jaki_kolor := not(jaki_kolor);

end; {koniec procedury klawisze}

{// G L O W N Y   P R O G R A M
{///////////////////////////////////////}

begin
{inicjalizacja zmiennych}
p_oz := 80;
widocznosc_t := 2; {to ustawienie jest odpowiednie dla naszego modelu}
sterownik := 5;
jaki_kolor := TRUE;
swiatlo.x := -1;
swiatlo.y := -1;
swiatlo.z := 1;
szciezka_do_t := 'tex.bmp';

{wlanczamy tryb graficzny 320x200x256}
g_ustaw_tryb_vga($13);

{pobranie pamieci dla drugiego bufora wideo i jego adresu}
g_pobierz_pam_dla_drugiego_bufora(adres_2_bufora);

{ladujemy teksture}
g_laduj_BMP_13h(tekstura, szciezka_do_t);

{ladujemy palete kolorow tekstury}
g_laduj_palete_BMP(szciezka_do_t);

{inicjuj tablice tab_cos i tab_sin}
g_inicjuj_tab_sin_i_cos;

while (klawisz <> 'p') do
begin

{jezeli nacisnieto klawisz}
if keypressed then klawisze;

{wykonanie kopii modelu szescianu}
move(szescian, bufor_t, sizeof(szescian));

{transformacje modelu}
g_obroc_trojkaty_wokol_osi_x(@bufor_t, kat_ox, 12);
g_obroc_trojkaty_wokol_osi_y(@bufor_t, kat_oy, 12);
g_obroc_trojkaty_wokol_osi_z(@bufor_t, kat_oz, 12);
g_przesun_trojkaty(@bufor_t, p_ox, p_oy, p_oz, 12);

if(sterownik = 1) then {metoda punktowa}
begin
{przygotowanie trojkatow do wyswietlenia}
g_przygotuj_trojkaty_do_rysowania_m_punktowa(@bufor_t,
                                             @bufor_w_roboczy,
                                             12,
                                             liczba_widocznych_t);

{wyswietlenie trojkatow}
if(liczba_widocznych_t <> 0) then
g_wyswietl_trojkaty_m_punktowa(adres_2_bufora, @bufor_w_roboczy,
                               liczba_widocznych_t, 4);
end; {koniec bloku if(sterownik = 1)}

if(sterownik = 2) then {metoda siatkowa}
begin
{przygotowanie trojkatow do wyswietlenia}
g_przygotuj_trojkaty_do_rysowania_m_siatkowa(@bufor_t,
                                             @bufor_w_roboczy,
                                             12,
                                             liczba_widocznych_t);

{wyswietlenie trojkatow}
if(liczba_widocznych_t <> 0) then
g_wyswietl_trojkaty_m_siatkowa(adres_2_bufora, @bufor_w_roboczy,
                               liczba_widocznych_t, 4);
end; {koniec bloku if(sterownik = 2}

if(sterownik = 3) then {metoda jednokolorowych trojkatow}
begin
{przygotowanie trojkatow do wyswietlenia}
g_przygotuj_trojkaty_do_rysowania_m_wypelnione(@bufor_t,
                                               @bufor_t_roboczy,
                                               12,
                                               liczba_widocznych_t);

{wyswietlenie trojkatow}
if(liczba_widocznych_t <> 0) then
g_wyswietl_trojkaty_m_wypelnione(adres_2_bufora, @bufor_t_roboczy,
                                 liczba_widocznych_t, 4, jaki_kolor);
end; {koniec bloku if(sterownik = 3}

if(sterownik = 4) then {metoda trojkatow cieniowanych plasko}
begin
{przygotowanie trojkatow do wyswietlenia}
g_przygotuj_trojkaty_do_rysowania_m_cieniowanie_p(@bufor_t,
                                                 @bufor_t_roboczy,
                                                 12,
                                                 liczba_widocznych_t,
                                                 swiatlo,
                                                 160,
                                                 20);

{wyswietlenie trojkatow}
if(liczba_widocznych_t <> 0) then
g_wyswietl_trojkaty_m_wypelnione(adres_2_bufora, @bufor_t_roboczy,
                                 liczba_widocznych_t, 4, jaki_kolor);
end; {koniec bloku if(sterownik = 4}

if(sterownik = 5) then {metoda trojkatow teksturowanych}
begin
{przygotowanie trojkatow do wyswietlenia}
g_przygotuj_trojkaty_do_rysowania_m_tekstura(@bufor_t,
                                             @bufor_t_roboczy,
                                              12,
                                              liczba_widocznych_t);

{wyswietlenie trojkatow}
if(liczba_widocznych_t <> 0) then
g_wyswietl_trojkaty_m_tekstura(adres_2_bufora, @bufor_t_roboczy,
                               liczba_widocznych_t, tekstura);
end; {koniec bloku if(sterownik = 5}

{wyswietlenie statystyki}
statystyka;

{skopiowanie drugiego bufora wideo do pamieci karty graficznej zgodnie
 z powrotem pionowym monitora}
g_czekaj_na_powrot_pionowy;
g_kopiuj_bufor(ptr($A000,0000), adres_2_bufora);

{wyczyszczenie drugiego bufora wideo przed kolejnym rysowaniem obrazu}
g_wypelnij_bufor(adres_2_bufora, 0);

{zmiana kata obrotu obiektu}
{os X:}
kat_ox := kat_ox + delta_kx;
if(kat_ox >  359) then kat_ox := kat_ox - 360;
if(kat_ox < -359) then kat_ox := kat_ox + 360;
{os Y:}
kat_oy := kat_oy + delta_ky;
if(kat_oy >  359) then kat_oy := kat_oy - 360;
if(kat_oy < -359) then kat_oy := kat_oy + 360;
{os Z:}
kat_oz := kat_oz + delta_kz;
if(kat_oz >  359) then kat_oz := kat_oz - 360;
if(kat_oz < -359) then kat_oz := kat_oz + 360;
end; {koniec petli while do}

{zwolnienie pamieci przydzielonej dla drugiego bufora wideo}
g_zwolnij_pam_bufora(adres_2_bufora);

end. {koniec programu}